﻿using System.Windows.Forms;
using System.Data.SqlClient;
using System.Data;
using System;
using System.IO;
using System.Text;

namespace TMC
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            conn.ConnectionString = "Data Source=" + Server_textBox1.Text + "," + Port_textBox1.Text + ";Network Library=DBMSSOCN;Initial Catalog=" + Database_textBox1.Text + ";User ID =" + User_textBox1.Text + ";Password=" + Password_textBox1.Text + ";";
        }

        private DataTable dataTable;

        private SqlConnection conn = new SqlConnection();

        private DateTime myDateTime;

        private void Conn_button1_Click(object sender, EventArgs e)
        {
            try
            {
                conn.ConnectionString = "Data Source=" + Server_textBox1.Text + "," + Port_textBox1.Text + ";Network Library=DBMSSOCN;Initial Catalog=" + Database_textBox1.Text + ";User ID =" + User_textBox1.Text + ";Password=" + Password_textBox1.Text + ";";
                conn.Open();
                MessageBox.Show("Соединение установлено!");
                conn.Close();
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show(Ex.ToString());
            }
        }

        private void Parse_file_button1_Click(object sender, EventArgs e)
        {
            try
            {
                using (var openFileDialog = new OpenFileDialog())
                {
                    openFileDialog.Filter = "*.txt | *.txt";
                    if (openFileDialog.ShowDialog() == DialogResult.OK)
                        Parse_file_textBox1.Text = (openFileDialog.FileName);
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Parse_file_button2_Click(object sender, EventArgs e)
        {
            try
            {
                myDateTime = Convert.ToDateTime(Date_textBox1.Text);

                dataTable = new DataTable();
                StreamReader streamreader = new StreamReader(Parse_file_textBox1.Text, Encoding.GetEncoding(1251)); // path and encoding
                char[] delimiter = new char[] { '\t' };
                string[] columnheaders = streamreader.ReadLine().Split(delimiter);
                foreach (string columnheader in columnheaders)
                {
                    dataTable.Columns.Add(columnheader); // I've added the column headers here.
                }

                while (streamreader.Peek() > 0)
                {
                    DataRow datarow = dataTable.NewRow();
                    datarow.ItemArray = streamreader.ReadLine().Split(delimiter);
                    dataTable.Rows.Add(datarow);
                }

                Parse_file_richTextBox1.Clear();
                if (Show_RE_checkBox1.Checked == true)
                    foreach (DataRow row in dataTable.Rows)
                    {
                        if (dataTable.Rows.IndexOf(row) == 0)
                            Parse_file_richTextBox1.AppendText("                                ----Row No: " + dataTable.Rows.IndexOf(row) + "----");
                        else
                            Parse_file_richTextBox1.AppendText("\r\n" + "                               ----Row No: " + dataTable.Rows.IndexOf(row) + "----");

                        foreach (DataColumn column in dataTable.Columns)
                        {
                            //check what columns you need
                            //if (column.ColumnName == "" ||
                            //column.ColumnName == "")
                            //{
                            Parse_file_richTextBox1.AppendText("\r\n" + column.ColumnName + ": " + row[column].ToString());
                            //}
                        }
                    }

                streamreader.Close();
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Refresh_log_button1_Click(object sender, EventArgs e)
        {
            try
            {
                Parse_file_richTextBox1.Clear();
                foreach (DataRow row in dataTable.Rows)
                {
                    if (dataTable.Rows.IndexOf(row) == 0)
                        Parse_file_richTextBox1.AppendText("                                ----Row No: " + dataTable.Rows.IndexOf(row) + "----");
                    else
                        Parse_file_richTextBox1.AppendText("\r\n" + "                               ----Row No: " + dataTable.Rows.IndexOf(row) + "----");

                    foreach (DataColumn column in dataTable.Columns)
                    {
                        //check what columns you need
                        //if (column.ColumnName == "" ||
                        //column.ColumnName == "")
                        //{
                        Parse_file_richTextBox1.AppendText("\r\n" + column.ColumnName + ": " + row[column].ToString());
                        //}
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Test_data_button1_Click(object sender, EventArgs e)
        {
            Test_data_richTextBox1.Clear();

            Add_MOL();
            Add_products();
            Add_docStr();
        }

        private void Get_EdIzId_button1_Click(object sender, EventArgs e)
        {
            try
            {
                conn.Open();

                Parse_file_richTextBox1.Clear();

                SqlCommand sqlCommand = new SqlCommand("SELECT EdizId, Ediz FROM maindatabase..SprEdiz", conn);

                using (SqlDataReader sqlDataReader = sqlCommand.ExecuteReader())
                {
                    while (sqlDataReader.Read())
                    {
                        Parse_file_richTextBox1.AppendText(sqlDataReader["EdizId"].ToString() + "      " + sqlDataReader["Ediz"] + "\r\n");
                    }
                }

                conn.Close();
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show(Ex.ToString());
            }
        }

        private void Get_id1_button1_Click(object sender, EventArgs e)
        {
            try
            {
                conn.Open();

                Parse_file_richTextBox1.Clear();

                SqlCommand sqlCommand = new SqlCommand("SELECT idSchetSubSchet FROM maindatabase..tbSprSchet WHERE kodSchet = " + kodSchet_textBox1.Text + " AND kodSubSchet = " + kodSubSchet_textBox1.Text, conn);

                string idSchetSubSchet = "-666";

                using (SqlDataReader sqlDataReader = sqlCommand.ExecuteReader())
                {
                    if (sqlDataReader.Read())
                        idSchetSubSchet = sqlDataReader["idSchetSubSchet"].ToString();
                }

                sqlCommand = new SqlCommand("SELECT id1, nameAPrizSchet FROM maindatabase..tbSprAPrizSchet WHERE idSchetSubSchet = " + idSchetSubSchet, conn);

                using (SqlDataReader sqlDataReader = sqlCommand.ExecuteReader())
                {
                    while (sqlDataReader.Read())
                    {
                        Parse_file_richTextBox1.AppendText(sqlDataReader["id1"].ToString() + "      " + sqlDataReader["nameAPrizSchet"] + "\r\n");
                    }
                }

                conn.Close();
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show(Ex.ToString());
            }
        }

        private void Delete_button1_Click(object sender, EventArgs e)
        {
            try
            {
                conn.Open();

                SqlCommand sqlCommand = new SqlCommand
                            (
                                "DELETE " +
                                "FROM " +
                                    "malocenka..SprMolM", conn
                            );

                sqlCommand.ExecuteNonQuery();

                sqlCommand = new SqlCommand
                            (
                                "DELETE " +
                                "FROM " +
                                    "malocenka..SprTovar", conn
                            );

                sqlCommand.ExecuteNonQuery();

                sqlCommand = new SqlCommand
                            (
                                "DELETE " +
                                "FROM " +
                                    "malocenka..DocMaloc", conn
                            );

                sqlCommand.ExecuteNonQuery();

                sqlCommand = new SqlCommand
                            (
                                "DELETE " +
                                "FROM " +
                                    "malocenka..StringMaloc", conn
                            );

                sqlCommand.ExecuteNonQuery();

                conn.Close();

                MessageBox.Show("Удалено!");
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show(Ex.ToString());
            }
        }

        private void Add_MOL()
        {
            string error = "-666";

            int TN = -666;
            string FIO = "-666";

            try
            {
                conn.Open();

                foreach (DataRow row in dataTable.Rows)
                {
                    TN = -666;
                    FIO = "-666";

                    foreach (DataColumn column in dataTable.Columns)
                    {
                        if (column.ColumnName == "TN")
                        {
                            error = row[column].ToString();
                            TN = Convert.ToInt32(row[column].ToString());
                        }

                        if (column.ColumnName == "FIO")
                            FIO = row[column].ToString();

                        if (TN != -666 && FIO != "-666")
                        {
                            SqlCommand sqlCommand = new SqlCommand("-666", conn);

                            if (Ignore_FIO_checkBox1.Checked == false)
                            {
                                sqlCommand = new SqlCommand
                                (
                                    "SELECT " +
                                        "COUNT(*) " +
                                    "FROM " +
                                        "malocenka..SprMolM " +
                                    "WHERE " +
                                        "KodSklM =" + TN + " AND " +
                                        "FIO ='" + FIO + "'", conn
                                );
                            }
                            else
                            {
                                sqlCommand = new SqlCommand
                                (
                                    "SELECT " +
                                        "COUNT(*) " +
                                    "FROM " +
                                        "malocenka..SprMolM " +
                                    "WHERE " +
                                        "KodSklM =" + TN, conn
                                );
                            }

                            int result = (int)sqlCommand.ExecuteScalar();

                            if (result <= 0)
                            {
                                sqlCommand = new SqlCommand
                                (
                                    "INSERT INTO " +
                                        "malocenka..SprMolM(idpredpr, TABN, FIO, PrIznos, KodSklM, MesInv, NamePredpr) " +
                                    "VALUES(" +
                                        ID_p_textBox1.Text + "," +
                                        0 + "," +
                                        "'" + FIO + "'," +
                                        PrIznos_textBox1.Text + "," +
                                        TN + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        "'" + Name_p_textBox1.Text + "'" +
                                    ")", conn
                                );

                                sqlCommand.ExecuteNonQuery();
                            }

                            TN = -666;
                            FIO = "-666";
                        }
                    }
                }

                conn.Close();

                Test_data_richTextBox1.AppendText("Add_MOL -> OK!\r\n");
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show("Add_MOL!!!      " + Ex.ToString() + "      " + error);
                MessageBox.Show("Add_MOL!!!      " + TN + ":" + FIO);
            }
        }

        private void Add_products()
        {
            string NamevidTovM = "-666";
            double CenoM = -666;
            int EdIzId = -666;

            try
            {
                conn.Open();

                foreach (DataRow row in dataTable.Rows)
                {
                    NamevidTovM = "-666";
                    CenoM = -666;
                    EdIzId = -666;

                    foreach (DataColumn column in dataTable.Columns)
                    {
                        if (column.ColumnName == "NamevidTovM")
                            NamevidTovM = row[column].ToString().Substring(0, Math.Min(row[column].ToString().Length, 29));

                        if (column.ColumnName == "CenoM")
                            CenoM = Convert.ToDouble(row[column].ToString());

                        if (column.ColumnName == "EdIzId")
                            EdIzId = Convert.ToInt32(row[column].ToString());

                        if (NamevidTovM != "-666" && CenoM != -666 && EdIzId != -666)
                        {
                            SqlCommand sqlCommand = new SqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM " +
                                    "malocenka..SprTovar " +
                                "WHERE " +
                                    "NameT ='" + NamevidTovM + "' AND " +
                                    "Ceno =" + CenoM + " AND " +
                                    "EdIzId =" + EdIzId, conn
                            );

                            int result = (int)sqlCommand.ExecuteScalar();

                            if (result <= 0)
                            {
                                sqlCommand = new SqlCommand
                                (
                                    "INSERT INTO " +
                                        "malocenka..SprTovar(NameT, Ceno, EdIzId, NDS, KodGr, Art, IdPrizlog) " +
                                    "VALUES(" +
                                        "'" + NamevidTovM + "'," +
                                        CenoM + "," +
                                        EdIzId + "," +
                                        NDS_textBox1.Text + "," +
                                        1 + "," +
                                        "''," +
                                        5 +
                                    ")", conn
                                );

                                sqlCommand.ExecuteNonQuery();
                            }

                            NamevidTovM = "-666";
                            CenoM = -666;
                            EdIzId = -666;
                        }
                    }
                }

                conn.Close();

                Test_data_richTextBox1.AppendText("Add_products -> OK!\r\n");
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show("Add_products!!!      " + Ex.ToString());
                MessageBox.Show("Add_products!!!      " + NamevidTovM + ":" + CenoM);
            }
        }

        private void Add_docStr()
        {
            int TN = -666;
            string FIO = "-666";
            string NamevidTovM = "-666";
            double CenoM = -666;
            double KolfM = -666;
            int EdIzId = -666;
            DateTime DateVV = DateTime.Now;
            int IdschetsubshetDtM = -666;

            try
            {
                conn.Open();

                Random random = new Random();

                foreach (DataRow row in dataTable.Rows)
                {
                    TN = -666;
                    FIO = "-666";
                    NamevidTovM = "-666";
                    CenoM = -666;
                    KolfM = -666;
                    EdIzId = -666;
                    DateVV = DateTime.Now;
                    IdschetsubshetDtM = -666;

                    foreach (DataColumn column in dataTable.Columns)
                    {
                        if (column.ColumnName == "TN")
                            TN = Convert.ToInt32(row[column].ToString());

                        if (column.ColumnName == "FIO")
                            FIO = row[column].ToString();

                        if (column.ColumnName == "NamevidTovM")
                            NamevidTovM = row[column].ToString().Substring(0, Math.Min(row[column].ToString().Length, 29));

                        if (column.ColumnName == "CenoM")
                            CenoM = Convert.ToDouble(row[column].ToString());

                        if (column.ColumnName == "KolfM")
                            KolfM = Convert.ToDouble(row[column].ToString());

                        if (column.ColumnName == "EdIzId")
                            EdIzId = Convert.ToInt32(row[column].ToString());

                        if (column.ColumnName == "DateVV")
                        {
                            DateVV = Convert.ToDateTime(row[column].ToString());
                        }

                        if (column.ColumnName == "IdschetsubshetDtM")
                            IdschetsubshetDtM = Convert.ToInt32(row[column].ToString());

                        if (TN != -666 && FIO != "-666" && NamevidTovM != "-666" && CenoM != -666 && KolfM != -666 && EdIzId != -666 && IdschetsubshetDtM != -666)
                        {
                            SqlCommand sqlCommand = new SqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM " +
                                    "malocenka..DocMaloc " +
                                "WHERE " +
                                    "KodSklM =" + TN + " AND " +
                                    "IdgroperM =" + ID_o_textBox1.Text + " AND " +
                                    "IdschetsubshetDtM =" + IdschetsubshetDtM, conn
                            );

                            int result = (int)sqlCommand.ExecuteScalar();

                            if (result == 1)
                            {
                                result = Get_idDocM(TN, IdschetsubshetDtM);

                                sqlCommand = new SqlCommand
                                (
                                    "INSERT INTO " +
                                        "malocenka..StringMaloc(CenoM, KolfM, DateVV, idIznos, KolMIzn, NDSM, DateOI, PNTM, CenoMOtpusk, idDocM, DateM, Idprizlog, Edizmer, SumNDSM, Artm, SumIzn, DateDocM, NamevidTovM) " +
                                    "VALUES(" +
                                        CenoM + "," +
                                        KolfM + "," +
                                        "'" + DateVV.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        1 + "," +
                                        0 + "," +
                                        0 + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        Get_PNTM(NamevidTovM, CenoM, EdIzId) + "," +
                                        CenoM + "," +
                                        result + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        5 + "," +
                                        "'" + Get_Edizmer(EdIzId) + "'," +
                                        0 + "," +
                                        "''," +
                                        0 + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        "'" + NamevidTovM + "'" +
                                    ")", conn
                                );

                                sqlCommand.ExecuteNonQuery();
                            }
                            else
                            {
                                int NumDocM = random.Next(23000);

                                bool boolCheck_NumDocM = true;

                                while (boolCheck_NumDocM == true)
                                {
                                    boolCheck_NumDocM = Check_NumDocM(NumDocM);

                                    if (boolCheck_NumDocM != false)
                                        NumDocM = random.Next(23000);
                                }

                                sqlCommand = new SqlCommand
                                (
                                    "INSERT INTO " +
                                        "malocenka..DocMaloc(NumDocM, DateDocM, VidDocM, ItogoM, SumNDSM, ItogoIznos, idGrOperM, KodSklM, IdschetsubshetDtM, IdPredprM, IdPredprMKor, KodsklMKor, IdsklM) " +
                                    "VALUES(" +
                                        NumDocM + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        1 + "," +
                                        0 + "," +
                                        0 + "," +
                                        0 + "," +
                                        ID_o_textBox1.Text + "," +
                                        TN + "," +
                                        IdschetsubshetDtM + "," +
                                        ID_p_textBox1.Text + "," +
                                        ID_p_textBox1.Text + "," +
                                        TN + "," +
                                        2 +
                                    ")", conn
                                );

                                sqlCommand.ExecuteNonQuery();

                                result = Get_idDocM(TN, IdschetsubshetDtM);

                                sqlCommand = new SqlCommand
                                (
                                    "INSERT INTO " +
                                        "malocenka..StringMaloc(CenoM, KolfM, DateVV, idIznos, KolMIzn, NDSM, DateOI, PNTM, CenoMOtpusk, idDocM, DateM, Idprizlog, Edizmer, SumNDSM, Artm, SumIzn, DateDocM, NamevidTovM) " +
                                    "VALUES(" +
                                        CenoM + "," +
                                        KolfM + "," +
                                        "'" + DateVV.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        1 + "," +
                                        0 + "," +
                                        0 + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        Get_PNTM(NamevidTovM, CenoM, EdIzId) + "," +
                                        CenoM + "," +
                                        result + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        5 + "," +
                                        "'" + Get_Edizmer(EdIzId) + "'," +
                                        0 + "," +
                                        "''," +
                                        0 + "," +
                                        "'" + myDateTime.ToString("yyyy-MM-dd HH:mm:ss") + "'," +
                                        "'" + NamevidTovM + "'" +
                                    ")", conn
                                );

                                sqlCommand.ExecuteNonQuery();
                            }

                            TN = -666;
                            FIO = "-666";
                            NamevidTovM = "-666";
                            CenoM = -666;
                            KolfM = -666;
                            EdIzId = -666;
                            IdschetsubshetDtM = -666;
                        }
                    }
                }

                if (Recalc_ItogoM_checkBox1.Checked == true)
                    RecalcItog();

                conn.Close();

                Test_data_richTextBox1.AppendText("Add_docStr -> OK!\r\n");
            }
            catch (Exception Ex)
            {
                conn.Close();

                MessageBox.Show("Add_docStr!!!      " + Ex.ToString());

                MessageBox.Show("Add_docStr!!!      " + NamevidTovM + ":" + CenoM + ":" + EdIzId);
            }
        }

        private int Get_PNTM(string NamevidTovM, double CenoM, int EdIzId)
        {
            SqlCommand sqlCommand = new SqlCommand
            (
                "SELECT " +
                    "PNT " +
                "FROM " +
                    "malocenka..SprTovar " +
                "WHERE " +
                    "NameT ='" + NamevidTovM + "' AND " +
                    "Ceno =" + CenoM + " AND " +
                    "EdIzId =" + EdIzId, conn
            );

            int PNTM = (int)sqlCommand.ExecuteScalar();

            return PNTM;
        }

        private string Get_Edizmer(int EdIzId)
        {
            SqlCommand sqlCommand = new SqlCommand
            (
                "SELECT " +
                    "Ediz " +
                "FROM " +
                    "maindatabase..SprEdiz " +
                "WHERE " +
                    "EdizId =" + EdIzId, conn
            );

            string Edizmer = (string)sqlCommand.ExecuteScalar();

            return Edizmer;
        }

        private bool Check_NumDocM(int NumDocM)
        {
            SqlCommand sqlCommand = new SqlCommand
            (
                "SELECT " +
                    "COUNT(*) " +
                "FROM " +
                    "malocenka..DocMaloc " +
                "WHERE " +
                    "NumDocM =" + NumDocM, conn
            );

            int check_NumDocM = (int)sqlCommand.ExecuteScalar();

            if (check_NumDocM == 0)
                return false;
            else
                return true;
        }

        private int Get_idDocM(int TN, int IdschetsubshetDtM)
        {
            SqlCommand sqlCommand = new SqlCommand
            (
                "SELECT " +
                    "idDocM " +
                "FROM " +
                    "malocenka..DocMaloc " +
                "WHERE " +
                    "KodSklM =" + TN + " AND " +
                    "IdgroperM =" + ID_o_textBox1.Text + " AND " +
                    "IdschetsubshetDtM =" + IdschetsubshetDtM, conn
            );

            return (int)sqlCommand.ExecuteScalar();
        }

        private void RecalcItog()
        {
            SqlCommand sqlCommand = new SqlCommand
            (
                "UPDATE " +
                    "malocenka..DocMaloc " +
                "SET " +
                    "ItogoM = " +
                        "IsNull((SELECT SUM(ROUND(CenoM * KolfM, 3)) " +
                        "FROM " +
                            "malocenka..StringMaloc " +
                        "WHERE " +
                            "malocenka..StringMaloc.IdDocM = malocenka..DocMaloc.IdDocM), 0)", conn
            );

            sqlCommand.ExecuteNonQuery();
        }

        private void Server_textBox1_TextChanged(object sender, EventArgs e)
        {
        }

        private void Database_textBox1_TextChanged(object sender, EventArgs e)
        {
        }

        private void Password_textBox1_TextChanged(object sender, EventArgs e)
        {
        }

        private void User_textBox1_TextChanged(object sender, EventArgs e)
        {
        }

        private void Port_textBox1_TextChanged(object sender, EventArgs e)
        {
        }
    }
}